

<?php $__env->startSection('title', 'Stock Management - The Smart School Education'); ?>
<?php $__env->startSection('page-title', 'Stock Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center gap-4">
        <div>
            <h2 class="text-xl font-semibold text-gray-800">Stock Items</h2>
            <p class="text-sm text-gray-600">Manage inventory</p>
        </div>
        <a href="<?php echo e(route('stock.create')); ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center justify-center sm:justify-start w-full sm:w-auto">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
            </svg>
            <span class="text-sm sm:text-base">Add Stock</span>
        </a>
    </div>
</div>

<!-- Filters -->
<div class="bg-white rounded-lg shadow p-4 mb-6">
    <form method="GET" action="<?php echo e(route('stock.index')); ?>" class="flex flex-col sm:flex-row gap-2 sm:gap-4">
        <select name="type" class="w-full sm:w-auto px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 text-sm sm:text-base">
            <option value="">All Types</option>
            <option value="book" <?php echo e(request('type') == 'book' ? 'selected' : ''); ?>>Books</option>
            <option value="uniform" <?php echo e(request('type') == 'uniform' ? 'selected' : ''); ?>>Uniforms</option>
        </select>
        <input type="text" name="search" value="<?php echo e(request('search')); ?>" 
               placeholder="Search by name..." 
               class="flex-1 w-full sm:w-auto px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 text-sm sm:text-base">
        <div class="flex gap-2">
            <button type="submit" class="bg-gray-600 hover:bg-gray-700 text-white px-4 sm:px-6 py-2 rounded-lg text-sm sm:text-base flex-1 sm:flex-none">
                Filter
            </button>
            <?php if(request('type') || request('search')): ?>
            <a href="<?php echo e(route('stock.index')); ?>" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 sm:px-6 py-2 rounded-lg text-sm sm:text-base">
                Clear
            </a>
            <?php endif; ?>
        </div>
    </form>
</div>

<!-- Alert Banner -->
<?php if($lowStockCount > 0): ?>
<div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6">
    <div class="flex">
        <div class="flex-shrink-0">
            <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
            </svg>
        </div>
        <div class="ml-3">
            <p class="text-sm text-red-700">
                <strong>Low Stock Alert:</strong> <?php echo e($lowStockCount); ?> item(s) are running low on stock. 
                <a href="<?php echo e(route('stock.alerts')); ?>" class="underline font-medium">View Alerts</a>
            </p>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Stock Table -->
<div class="bg-white rounded-lg shadow overflow-hidden">
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Quantity</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Alert Level</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit Price</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Arrival Date</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $stockItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50 <?php echo e($item->isLowStock() ? 'bg-red-50' : ''); ?>">
                    <td class="px-4 py-3 text-sm font-medium text-gray-900"><?php echo e($item->name); ?></td>
                    <td class="px-4 py-3 text-sm text-gray-500">
                        <span class="px-2 py-1 text-xs rounded-full <?php echo e($item->type == 'book' ? 'bg-blue-100 text-blue-800' : 'bg-purple-100 text-purple-800'); ?>">
                            <?php echo e(ucfirst($item->type)); ?>

                        </span>
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-900 font-medium"><?php echo e($item->quantity); ?></td>
                    <td class="px-4 py-3 text-sm text-gray-500"><?php echo e($item->alert_threshold); ?></td>
                    <td class="px-4 py-3 text-sm text-gray-900">Rs. <?php echo e(number_format($item->unit_price, 2)); ?></td>
                    <td class="px-4 py-3 text-sm text-gray-500"><?php echo e($item->arrival_date ? $item->arrival_date->format('d M Y') : '-'); ?></td>
                    <td class="px-4 py-3 text-sm">
                        <?php if($item->isLowStock()): ?>
                            <span class="px-2 py-1 text-xs rounded-full bg-red-100 text-red-800 font-medium">Low Stock</span>
                        <?php else: ?>
                            <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">In Stock</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-4 py-3 text-right text-sm font-medium">
                        <div class="flex justify-end gap-2">
                            <a href="<?php echo e(route('stock.show', $item)); ?>" class="text-blue-600 hover:text-blue-900">View</a>
                            <a href="<?php echo e(route('stock.edit', $item)); ?>" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                            <form action="<?php echo e(route('stock.destroy', $item)); ?>" method="POST" class="inline" onsubmit="return confirm('Are you sure?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-900">Delete</button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" class="px-6 py-4 text-center text-sm text-gray-500">
                        No stock items found. <a href="<?php echo e(route('stock.create')); ?>" class="text-blue-600 hover:underline">Add your first stock item</a>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if($stockItems->hasPages()): ?>
    <div class="bg-gray-50 px-4 py-3 border-t border-gray-200">
        <?php echo e($stockItems->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\abdar\resources\views/stock/index.blade.php ENDPATH**/ ?>