

<?php $__env->startSection('title', 'Edit Stock - The Smart School Education'); ?>
<?php $__env->startSection('page-title', 'Edit Stock Item'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <a href="<?php echo e(route('stock.index')); ?>" class="text-blue-600 hover:text-blue-800 flex items-center">
        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
        </svg>
        Back to Stock
    </a>
</div>

<div class="bg-white rounded-lg shadow p-6">
    <form action="<?php echo e(route('stock.update', $stockItem)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Name -->
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Item Name *</label>
                <input type="text" name="name" id="name" value="<?php echo e(old('name', $stockItem->name)); ?>" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
            </div>

            <!-- Type -->
            <div>
                <label for="type" class="block text-sm font-medium text-gray-700 mb-2">Type *</label>
                <select name="type" id="type" required
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
                    <option value="book" <?php echo e(old('type', $stockItem->type) == 'book' ? 'selected' : ''); ?>>Book</option>
                    <option value="uniform" <?php echo e(old('type', $stockItem->type) == 'uniform' ? 'selected' : ''); ?>>Uniform</option>
                </select>
            </div>

            <!-- Quantity -->
            <div>
                <label for="quantity" class="block text-sm font-medium text-gray-700 mb-2">Quantity *</label>
                <input type="number" name="quantity" id="quantity" value="<?php echo e(old('quantity', $stockItem->quantity)); ?>" min="0" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
            </div>

            <!-- Alert Threshold -->
            <div>
                <label for="alert_threshold" class="block text-sm font-medium text-gray-700 mb-2">Alert Threshold *</label>
                <input type="number" name="alert_threshold" id="alert_threshold" value="<?php echo e(old('alert_threshold', $stockItem->alert_threshold)); ?>" min="0" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
            </div>

            <!-- Unit Price -->
            <div>
                <label for="unit_price" class="block text-sm font-medium text-gray-700 mb-2">Unit Price (Rs.) *</label>
                <input type="number" name="unit_price" id="unit_price" value="<?php echo e(old('unit_price', $stockItem->unit_price)); ?>" step="0.01" min="0" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
            </div>

            <!-- Arrival Date -->
            <div>
                <label for="arrival_date" class="block text-sm font-medium text-gray-700 mb-2">Arrival Date</label>
                <input type="date" name="arrival_date" id="arrival_date" value="<?php echo e(old('arrival_date', $stockItem->arrival_date ? $stockItem->arrival_date->format('Y-m-d') : '')); ?>"
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500">
            </div>
        </div>

        <!-- Description -->
        <div class="mt-6">
            <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
            <textarea name="description" id="description" rows="3"
                      class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500"><?php echo e(old('description', $stockItem->description)); ?></textarea>
        </div>

        <!-- Buttons -->
        <div class="mt-6 flex justify-end gap-4">
            <a href="<?php echo e(route('stock.index')); ?>" class="px-6 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Update Stock Item
            </button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\abdar\resources\views/stock/edit.blade.php ENDPATH**/ ?>