@extends('layouts.app')

@section('title', 'Students - The Smart School Education')
@section('page-title', 'Students')

@section('content')
<div class="mb-6">
    <div class="flex flex-col md:flex-row md:justify-between md:items-center gap-4">
        <div>
            <h2 class="text-xl font-semibold text-gray-800">All Students</h2>
            <p class="text-sm text-gray-600">Manage student records</p>
        </div>
        <div class="flex flex-col sm:flex-row gap-2 sm:gap-3 w-full sm:w-auto">
            <a href="{{ route('students.print', request()->query()) }}" target="_blank" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg flex items-center justify-center sm:justify-start">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                </svg>
                <span class="text-sm sm:text-base">Print</span>
            </a>
            <a href="{{ route('students.create') }}" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center justify-center sm:justify-start">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
                <span class="text-sm sm:text-base">Add New Student</span>
            </a>
        </div>
    </div>
</div>

<!-- Search Bar -->
<div class="bg-white rounded-lg shadow p-4 mb-6">
    <form method="GET" action="{{ route('students.index') }}" class="flex flex-col sm:flex-row gap-2 sm:gap-4">
        <input type="text" name="search" value="{{ request('search') }}" 
               placeholder="Search by name, admission number..." 
               class="flex-1 px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent text-sm sm:text-base">
        <div class="flex gap-2">
            <button type="submit" class="bg-gray-600 hover:bg-gray-700 text-white px-4 sm:px-6 py-2 rounded-lg text-sm sm:text-base flex-1 sm:flex-none">
                Search
            </button>
            @if(request('search'))
            <a href="{{ route('students.index') }}" class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 sm:px-6 py-2 rounded-lg text-sm sm:text-base">
                Clear
            </a>
            @endif
        </div>
    </form>
</div>

<!-- Students Table -->
<div class="bg-white rounded-lg shadow overflow-hidden">
    <div class="overflow-x-auto" style="max-width: 100%;">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">S.No</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Father</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Class</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Admission Form</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Monthly Fees</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Annual Charges</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Due</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Paid</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Remaining</th>
                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Remarks</th>
                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($students as $index => $student)
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-900">{{ $students->firstItem() + $index }}</td>
                    <td class="px-4 py-3 whitespace-nowrap text-sm font-medium text-gray-900">{{ $student->name }}</td>
                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500">{{ $student->father_name ?? '-' }}</td>
                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500">{{ $student->class ?? '-' }}</td>
                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500">Rs. {{ number_format($student->admission_form, 2) }}</td>
                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500">Rs. {{ number_format($student->monthly_fees, 2) }}</td>
                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500">Rs. {{ number_format($student->annual_charges, 2) }}</td>
                    @php
                        $totalDue = $student->admission_form + $student->monthly_fees + $student->annual_charges;
                        $totalPaid = $student->total_fees_paid;
                        $remaining = $student->arrears;
                    @endphp
                    <td class="px-4 py-3 whitespace-nowrap text-sm font-medium text-gray-900">
                        Rs. {{ number_format($totalDue, 2) }}
                    </td>
                    <td class="px-4 py-3 whitespace-nowrap text-sm font-medium text-green-600">
                        Rs. {{ number_format($totalPaid, 2) }}
                    </td>
                    <td class="px-4 py-3 whitespace-nowrap text-sm font-bold {{ $remaining > 0 ? 'text-red-600' : 'text-green-600' }}">
                        Rs. {{ number_format($remaining, 2) }}
                        @if($remaining > 0)
                            <span class="text-xs font-normal text-red-500">(Pending)</span>
                        @else
                            <span class="text-xs font-normal text-green-500">(Paid)</span>
                        @endif
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-500">{{ $student->remarks ? \Illuminate\Support\Str::limit($student->remarks, 30) : '-' }}</td>
                    <td class="px-4 py-3 whitespace-nowrap text-right text-sm font-medium">
                        <div class="flex justify-end gap-2">
                            <a href="{{ route('students.print-single', $student) }}" target="_blank" class="text-green-600 hover:text-green-900" title="Print">
                                <svg class="w-4 h-4 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                                </svg>
                            </a>
                            <a href="{{ route('students.show', $student) }}" class="text-blue-600 hover:text-blue-900">View</a>
                            <a href="{{ route('students.edit', $student) }}" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                            <form action="{{ route('students.destroy', $student) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this student?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-900">Delete</button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="12" class="px-6 py-4 text-center text-sm text-gray-500">
                        No students found. <a href="{{ route('students.create') }}" class="text-blue-600 hover:underline">Add your first student</a>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    @if($students->hasPages())
    <div class="bg-gray-50 px-4 py-3 border-t border-gray-200">
        {{ $students->links() }}
    </div>
    @endif
</div>
@endsection

