@extends('layouts.app')

@section('title', 'Add Student - The Smart School Education')
@section('page-title', 'Add New Student')

@section('content')
<div class="bg-white rounded-lg shadow p-6">
    <form action="{{ route('students.store') }}" method="POST">
        @csrf

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Admission Number -->
            <div>
                <label for="admission_number" class="block text-sm font-medium text-gray-700 mb-2">Admission Number *</label>
                <input type="text" name="admission_number" id="admission_number" value="{{ old('admission_number') }}" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('admission_number') border-red-500 @enderror">
                @error('admission_number')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Name -->
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Name *</label>
                <input type="text" name="name" id="name" value="{{ old('name') }}" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('name') border-red-500 @enderror">
                @error('name')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Father Name -->
            <div>
                <label for="father_name" class="block text-sm font-medium text-gray-700 mb-2">Father</label>
                <input type="text" name="father_name" id="father_name" value="{{ old('father_name') }}"
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
            </div>

            <!-- Class -->
            <div>
                <label for="class" class="block text-sm font-medium text-gray-700 mb-2">Class</label>
                <input type="text" name="class" id="class" value="{{ old('class') }}"
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
            </div>

            <!-- Admission Date -->
            <div>
                <label for="admission_date" class="block text-sm font-medium text-gray-700 mb-2">Admission Date *</label>
                <input type="date" name="admission_date" id="admission_date" value="{{ old('admission_date', date('Y-m-d')) }}" required
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('admission_date') border-red-500 @enderror">
                @error('admission_date')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Admission Form -->
            <div>
                <label for="admission_form" class="block text-sm font-medium text-gray-700 mb-2">Admission Form (Rs.)</label>
                <input type="number" name="admission_form" id="admission_form" value="{{ old('admission_form', 0) }}" step="0.01" min="0"
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
            </div>

            <!-- Monthly Fees -->
            <div>
                <label for="monthly_fees" class="block text-sm font-medium text-gray-700 mb-2">Monthly Fees (Rs.)</label>
                <input type="number" name="monthly_fees" id="monthly_fees" value="{{ old('monthly_fees', 0) }}" step="0.01" min="0"
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
            </div>

            <!-- Annual Charges -->
            <div>
                <label for="annual_charges" class="block text-sm font-medium text-gray-700 mb-2">Annual Charges (Rs.)</label>
                <input type="number" name="annual_charges" id="annual_charges" value="{{ old('annual_charges', 0) }}" step="0.01" min="0"
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
            </div>
        </div>

        <!-- Remarks -->
        <div class="mt-6">
            <label for="remarks" class="block text-sm font-medium text-gray-700 mb-2">Remarks</label>
            <textarea name="remarks" id="remarks" rows="3"
                      class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">{{ old('remarks') }}</textarea>
        </div>

        <!-- Buttons -->
        <div class="mt-6 flex justify-end gap-4">
            <a href="{{ route('students.index') }}" class="px-6 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Save Student
            </button>
        </div>
    </form>
</div>
@endsection
