@extends('layouts.app')

@section('title', 'Stock Details - The Smart School Education')
@section('page-title', 'Stock Item Details')

@section('content')
<div class="mb-6">
    <a href="{{ route('stock.index') }}" class="text-blue-600 hover:text-blue-800 flex items-center">
        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
        </svg>
        Back to Stock
    </a>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex justify-between items-start mb-6">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900">{{ $stockItem->name }}</h2>
                    <p class="text-gray-600">
                        <span class="px-2 py-1 text-xs rounded-full {{ $stockItem->type == 'book' ? 'bg-blue-100 text-blue-800' : 'bg-purple-100 text-purple-800' }}">
                            {{ ucfirst($stockItem->type) }}
                        </span>
                    </p>
                </div>
                <a href="{{ route('stock.edit', $stockItem) }}" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                    Edit
                </a>
            </div>

            <div class="grid grid-cols-2 gap-6">
                <div>
                    <label class="text-sm font-medium text-gray-500">Current Stock</label>
                    <p class="text-2xl font-bold {{ $stockItem->isLowStock() ? 'text-red-600' : 'text-green-600' }}">
                        {{ $stockItem->quantity }}
                    </p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Alert Threshold</label>
                    <p class="text-2xl font-bold text-gray-900">{{ $stockItem->alert_threshold }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Unit Price</label>
                    <p class="text-xl font-bold text-gray-900">Rs. {{ number_format($stockItem->unit_price, 2) }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Arrival Date</label>
                    <p class="text-lg text-gray-900">{{ $stockItem->arrival_date ? $stockItem->arrival_date->format('d M Y') : '-' }}</p>
                </div>
                @if($stockItem->description)
                <div class="col-span-2">
                    <label class="text-sm font-medium text-gray-500">Description</label>
                    <p class="text-gray-900">{{ $stockItem->description }}</p>
                </div>
                @endif
            </div>
        </div>

        <!-- Sales History -->
        @if($stockItem->type == 'book' && $stockItem->bookPurchases->count() > 0)
        <div class="bg-white rounded-lg shadow p-6 mt-6">
            <h3 class="text-lg font-semibold mb-4">Book Sales History</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Quantity</th>
                            <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($stockItem->bookPurchases as $purchase)
                        <tr>
                            <td class="px-4 py-3 text-sm">{{ $purchase->purchase_date->format('d M Y') }}</td>
                            <td class="px-4 py-3 text-sm">{{ $purchase->student->name }}</td>
                            <td class="px-4 py-3 text-sm">{{ $purchase->quantity }}</td>
                            <td class="px-4 py-3 text-sm text-right font-medium">Rs. {{ number_format($purchase->total_amount, 2) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endif

        @if($stockItem->type == 'uniform' && $stockItem->uniformPurchases->count() > 0)
        <div class="bg-white rounded-lg shadow p-6 mt-6">
            <h3 class="text-lg font-semibold mb-4">Uniform Sales History</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Quantity</th>
                            <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($stockItem->uniformPurchases as $purchase)
                        <tr>
                            <td class="px-4 py-3 text-sm">{{ $purchase->purchase_date->format('d M Y') }}</td>
                            <td class="px-4 py-3 text-sm">{{ $purchase->student->name }}</td>
                            <td class="px-4 py-3 text-sm">{{ $purchase->quantity }}</td>
                            <td class="px-4 py-3 text-sm text-right font-medium">Rs. {{ number_format($purchase->total_amount, 2) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endif
    </div>

    <div>
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold mb-4">Summary</h3>
            <div class="space-y-4">
                <div>
                    <label class="text-sm font-medium text-gray-500">Total Sold</label>
                    <p class="text-xl font-bold text-gray-900">{{ $stockItem->total_sold }}</p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Available Stock</label>
                    <p class="text-xl font-bold {{ $stockItem->isLowStock() ? 'text-red-600' : 'text-green-600' }}">
                        {{ $stockItem->quantity }}
                    </p>
                </div>
                <div>
                    <label class="text-sm font-medium text-gray-500">Status</label>
                    <p class="mt-1">
                        @if($stockItem->isLowStock())
                            <span class="px-3 py-1 text-sm rounded-full bg-red-100 text-red-800 font-medium">Low Stock</span>
                        @else
                            <span class="px-3 py-1 text-sm rounded-full bg-green-100 text-green-800 font-medium">In Stock</span>
                        @endif
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

