<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('students', function (Blueprint $table) {
            $table->decimal('admission_form', 10, 2)->default(0)->after('class');
            $table->decimal('monthly_fees', 10, 2)->default(0)->after('admission_form');
            $table->decimal('annual_charges', 10, 2)->default(0)->after('monthly_fees');
            $table->text('remarks')->nullable()->after('annual_charges');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('students', function (Blueprint $table) {
            $table->dropColumn(['admission_form', 'monthly_fees', 'annual_charges', 'remarks']);
        });
    }
};
