<?php

namespace App\Http\Controllers;

use App\Models\Student;
use App\Models\StockItem;
use App\Models\LedgerEntry;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    /**
     * Show the application dashboard.
     */
    public function index()
    {
        $totalStudents = Student::count();
        $totalFeesCollected = LedgerEntry::where('transaction_type', 'fee_payment')
            ->where('entry_type', 'income')
            ->sum('amount');
        $outstandingFees = Student::get()->sum('arrears');
        $totalStockItems = StockItem::count();
        $lowStockCount = StockItem::whereRaw('quantity <= alert_threshold')->count();
        
        $recentTransactions = LedgerEntry::with('student')
            ->latest('transaction_date')
            ->take(10)
            ->get();

        return view('dashboard', compact(
            'totalStudents',
            'totalFeesCollected',
            'outstandingFees',
            'totalStockItems',
            'lowStockCount',
            'recentTransactions'
        ));
    }
}
